/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;

public class HeatRecipeSerializer
extends ExNihiloRecipeSerializer<HeatRecipe> {
    private static final JsonParser PARSER = new JsonParser();

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_FIRED.get());
    }

    public HeatRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.m_130277_()));
        int amount = buffer.readInt();
        boolean hasProperties = buffer.readBoolean();
        if (hasProperties) {
            StatePropertiesPredicate properties = StatePropertiesPredicate.m_67679_((JsonElement)PARSER.parse(buffer.m_130277_()));
            return new HeatRecipe(recipeId, input, amount, properties);
        }
        return new HeatRecipe(recipeId, input, amount);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull HeatRecipe recipe) {
        ResourceLocation resourceLocation = recipe.getInput().getRegistryName();
        if (resourceLocation == null) {
            return;
        }
        buffer.m_130070_(resourceLocation.toString());
        buffer.writeInt(recipe.getAmount());
        StatePropertiesPredicate properties = recipe.getProperties();
        boolean hasProperties = properties != null;
        buffer.writeBoolean(hasProperties);
        if (hasProperties) {
            buffer.m_130070_(properties.m_67666_().toString());
        }
    }

    @Override
    @Nonnull
    protected HeatRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()));
        int amount = json.get("amount").getAsInt();
        if (json.has("state")) {
            return new HeatRecipe(recipeId, input, amount, StatePropertiesPredicate.m_67679_((JsonElement)json.get("state")));
        }
        return new HeatRecipe(recipeId, input, amount);
    }
}

